package de.bebagoe.figuren.kreis;

import de.bebagoe.figuren.Figur;

public class Kreis extends Figur {
    protected double radius;

    public Kreis(double x, double y, double rad) {
        if (x < 0 || y < 0 || rad < 0)
            throw new IllegalArgumentException("Kreis part. außerhalb oder Radius < 0");
        radius = rad;
//        xpos = x; // verbotener Zugriff auf Basisklassenfeld vor dem Aufruf des Basisklassenkonstruktors
        super(x, y);
    }

    public Kreis() {
        radius = 50.0;
        super();
    }

    public double getRadius() { return radius; }

    // Direktzugriff auf die geerbten Felder xpos und ypos
	public double abstand(double x, double y) {
		return Math.sqrt(Math.pow(xpos+radius-x, 2) + Math.pow(ypos+radius-y, 2));
	}

//	public void illegalFigurAccess() {
//		var f = new Figur(10.0, 10.0);
//		f.xpos = 13.13;
//	}
}







